/*
 * Decompiled with CFR 0.152.
 */
package com.ale.SOAPSign;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SOAPClientSample {
    static final String NS_WSU = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    static final String NS_WSSE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    static final String NS_WS_X509 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    static final String NS_WS_ENC = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    static final String NS_XMLDSIG = "http://www.w3.org/2000/09/xmldsig#";
    static final String ALG_DIGEST = "http://www.w3.org/2001/04/xmlenc#sha512";
    static final String ALG_CANON = "http://www.w3.org/2001/10/xml-exc-c14n#";
    static final String ALG_SIG_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public String fileMessage;
    String certP12Path;
    String aliasCert;
    String certPwd;
    String fileSOAP;
    String soapServiceUrl;
    String fileResult;

    public void main() throws Exception {
        SOAPClientSample client = new SOAPClientSample();
        Document doc = client.readInXMLFile();
        SOAPMessage msg = client.createSOAPEnvelope(doc);
        msg = client.signSOAPMessage(msg);
        client.outputSOAPMessageToFile(msg);
        client.callTheWebServiceFromFile();
    }

    public Document readInXMLFile() throws ParserConfigurationException, SAXException, IOException {
        File requestFile = new File(this.fileMessage);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(requestFile);
        return doc;
    }

    public SOAPMessage createSOAPEnvelope(Document xmlDocument) throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        SOAPBody soapBody = soapMessage.getSOAPBody();
        soapBody.addDocument(xmlDocument);
        soapBody.addAttribute(soapEnvelope.createName("Id", "wsu", NS_WSU), "Body");
        return soapMessage;
    }

    public SOAPMessage signSOAPMessage(SOAPMessage soapMessage) throws Exception {
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        SOAPElement securityElement = soapHeader.addChildElement("Security", "wsse", NS_WSSE);
        securityElement.addNamespaceDeclaration("wsu", NS_WSU);
        Certificate cert = this.getCertificate();
        this.addBinarySecurityToken(securityElement, cert);
        this.addSignature(securityElement, soapMessage.getSOAPBody(), null);
        return soapMessage;
    }

    private SOAPElement addTimestamp(SOAPElement securityElement, SOAPMessage soapMessage) throws SOAPException {
        SOAPElement timestamp = securityElement.addChildElement("Timestamp", "wsu");
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        timestamp.addAttribute(soapEnvelope.createName("Id", "wsu", NS_WSU), "TS");
        String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
        DateTimeFormatter timeStampFormatter = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
        timestamp.addChildElement("Created", "wsu").setValue(timeStampFormatter.format(ZonedDateTime.now().toInstant().atZone(ZoneId.of("UTC"))));
        timestamp.addChildElement("Expires", "wsu").setValue(timeStampFormatter.format(ZonedDateTime.now().plusSeconds(30L).toInstant().atZone(ZoneId.of("UTC"))));
        return timestamp;
    }

    private Certificate getCertificate() throws Exception {
        String password = this.certPwd;
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(new FileInputStream(new File(this.certP12Path)), password.toCharArray());
        Certificate cert = keystore.getCertificate(this.aliasCert);
        return cert;
    }

    private SOAPElement addBinarySecurityToken(SOAPElement securityElement, Certificate cert) throws Exception {
        byte[] certByte = cert.getEncoded();
        SOAPElement binarySecurityToken = securityElement.addChildElement("BinarySecurityToken", "wsse");
        binarySecurityToken.setAttribute("ValueType", NS_WS_X509);
        binarySecurityToken.setAttribute("EncodingType", NS_WS_ENC);
        binarySecurityToken.setAttribute("wsu:Id", "X509Token");
        binarySecurityToken.addTextNode(Base64.getEncoder().encodeToString(certByte));
        return securityElement;
    }

    private SOAPElement addSignature(SOAPElement securityElement, SOAPBody soapBody, SOAPElement timestamp) throws Exception {
        PrivateKey key = this.getKeyFormCert();
        SOAPElement securityTokenReference = this.addSecurityToken(securityElement);
        this.createDetachedSignature(securityElement, key, securityTokenReference, soapBody, timestamp);
        return securityElement;
    }

    private PrivateKey getKeyFormCert() throws Exception {
        String password = this.certPwd;
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(new FileInputStream(new File(this.certP12Path)), password.toCharArray());
        PrivateKey key = (PrivateKey)keystore.getKey(this.aliasCert, password.toCharArray());
        return key;
    }

    private SOAPElement addSecurityToken(SOAPElement signature) throws SOAPException {
        SOAPElement securityTokenReference = signature.addChildElement("SecurityTokenReference", "wsse");
        SOAPElement reference = securityTokenReference.addChildElement("Reference", "wsse");
        reference.setAttribute("ValueType", NS_WS_X509);
        reference.setAttribute("URI", "#X509Token");
        return securityTokenReference;
    }

    private void createDetachedSignature(SOAPElement signatureElement, PrivateKey privateKey, SOAPElement securityTokenReference, SOAPBody soapBody, SOAPElement timestamp) throws Exception {
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        DigestMethod digestMethod = xmlSignatureFactory.newDigestMethod(ALG_DIGEST, null);
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        Transform envTransform = xmlSignatureFactory.newTransform(ALG_CANON, (TransformParameterSpec)null);
        transformList.add(envTransform);
        ArrayList<Reference> refList = new ArrayList<Reference>();
        Reference refBody = xmlSignatureFactory.newReference("#Body", digestMethod, transformList, null, null);
        refList.add(refBody);
        CanonicalizationMethod cm = xmlSignatureFactory.newCanonicalizationMethod(ALG_CANON, (C14NMethodParameterSpec)null);
        SignatureMethod sm = xmlSignatureFactory.newSignatureMethod(ALG_SIG_METHOD, null);
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(cm, sm, refList);
        DOMSignContext signContext = new DOMSignContext(privateKey, (Node)signatureElement);
        signContext.setDefaultNamespacePrefix("ds");
        signContext.putNamespacePrefix(NS_XMLDSIG, "ds");
        signContext.setIdAttributeNS((Element)soapBody, NS_WSU, "Id");
        KeyInfoFactory keyFactory = KeyInfoFactory.getInstance();
        DOMStructure domKeyInfo = new DOMStructure((Node)securityTokenReference);
        KeyInfo keyInfo = keyFactory.newKeyInfo(Collections.singletonList(domKeyInfo));
        XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo);
        signContext.setBaseURI("");
        signature.sign(signContext);
    }

    public void outputSOAPMessageToFile(SOAPMessage soapMessage) throws SOAPException, IOException {
        File outputFile = new File(this.fileSOAP);
        FileOutputStream fos = new FileOutputStream(outputFile);
        soapMessage.writeTo((OutputStream)fos);
        fos.close();
    }

    public void callTheWebServiceFromFile() throws IOException, SOAPException {
        File soapFile = new File(this.fileSOAP);
        FileInputStream fis = new FileInputStream(soapFile);
        StreamSource ss = new StreamSource(fis);
        SOAPMessage msg = MessageFactory.newInstance().createMessage();
        SOAPPart soapPart = msg.getSOAPPart();
        soapPart.setContent((Source)ss);
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        System.out.println("El endpoint es " + this.soapServiceUrl);
        String soapEndpointUrl = this.soapServiceUrl;
        SOAPMessage resp = soapConnection.call(msg, (Object)soapEndpointUrl);
        resp.writeTo((OutputStream)System.out);
        resp.writeTo((OutputStream)new FileOutputStream(this.fileResult));
        fis.close();
        soapConnection.close();
    }
}

